#include "model_utils.hpp"

void check_variable_domains(
    const police::SATModel& model,
    const police::VariableSpace& vspace)
{
    REQUIRE(model.size() >= vspace.size());
    check_variable_domains(model, vspace, [](police::size_t var) {
        return var;
    });
}

void check_variable_types(
    const police::SATModel& model,
    const police::VariableSpace& vspace)
{
    REQUIRE(model.size() >= vspace.size());
    check_variable_types(model, vspace, [](police::size_t var) { return var; });
}
