#include "binary_shifter.hpp"

namespace {
using namespace police;

LinearConstraint
create_constraint(police::size_t var, int val, LinearConstraint::Type type)
{
    LinearConstraint res(type);
    res.insert(var, 1.);
    res.rhs = val;
    return res;
}

LinearExpression create_const_expression(int val)
{
    LinearExpression res;
    res.bias = val;
    return res;
}

} // namespace

Model binary_shifter_model(int bits)
{
    VariableSpace variables;
    for (int i = 0; i < bits; ++i) {
        variables.add_variable("", BoundedIntType(0, 1));
    }
    vector<Action> actions;
    for (int i = 1; i < bits; ++i) {
        LinearConstraintConjunction guard;
        guard &= create_constraint(i, 1, LinearConstraint::Type::EQUAL);
        guard &= create_constraint(i - 1, 0, LinearConstraint::Type::EQUAL);
        vector<Assignment> effs;
        effs.emplace_back(i - 1, create_const_expression(1));
        effs.emplace_back(i, create_const_expression(0));
        actions.push_back(
            Action(0, std::move(guard), {Outcome(std::move(effs))}));
    }
    for (int i = 0; i + 1 < bits; ++i) {
        LinearConstraintConjunction guard;
        guard &= create_constraint(i, 1, LinearConstraint::Type::EQUAL);
        guard &= create_constraint(i + 1, 0, LinearConstraint::Type::EQUAL);
        vector<Assignment> effs;
        effs.emplace_back(i, create_const_expression(0));
        effs.emplace_back(i + 1, create_const_expression(1));
        actions.push_back(
            Action(1, std::move(guard), {Outcome(std::move(effs))}));
    }
    return Model(std::move(variables), std::move(actions), {});
}

police::LinearCondition binary_shifter_goal(int bits)
{
    police::LinearCondition res;
    police::LinearConstraint con(police::LinearConstraint::EQUAL);
    con.insert(bits - 1, 1.);
    con.rhs = 1;
    res |= con;
    return res;
}
