# PolIC3

## Dependencies

- CMake
- A C++ compiler with C++-20 support
- Z3 library
- For neural network support: Eigen library
- For tree ensemble support: Veritas
- For ASNet support: cpddl
- [Dynet](https://github.com/clab/dynet.git) for cpddl

## Building

1. Make available Z3 installation via

```sh
export Z3_HOME=<PATH-TO-Z3>
```
where the folder `<PATH-TO-Z3>` should contain `lib` and `include` sub-folders.

2. Build custom veritas version in ext/veritas

```sh
mkdir -p ext/veritas/build
cd ext/veritas/build
cmake -DCMAKE_BUILD_TYPE=Release ..
cmake --build .
```

3. Build custom cpddl version in ext/cpddl

```sh
cd ext/cpddl/
echo "DYNET_ROOT=<PATH_TO_DYNET>" > Makefile.config
./scripts/build.sh
```

4. Build polic3

```sh
mkdir build
cd build
cmake -DCMAKE_BUILD_TYPE=Release ..
cmake --build .
```

## Running

### Neural-network policy

- With reason generalization disabled

```sh
./build/police \
    --jani <path-to-jani-model> \
    --jani-additional-properties <path-to-jani-properties-file> \
    --policy <path-to-nnet> \
    --policy-adapter <path-to-jani2nnet> \
    --run "synic3(policy_reasoner=disabled)" \
    --applicability-mask
```

- Additional policy reasoning to compute stronger reasons

```sh
./build/police \
    --jani <path-to-jani-model> \
    --jani-additional-properties <path-to-jani-properties-file> \
    --policy <path-to-nnet> \
    --policy-adapter <path-to-jani2nnet> \
    --run "synic3(policy_reasoner=lipa)" \
    --applicability-mask
```

### Tree-ensemble policy

- With reason generalization disabled

```sh
./build/police \
    --jani <path-to-jani-model> \
    --jani-additional-properties <path-to-jani-properties-file> \
    --policy <path-to-json> \
    --policy-adapter <path-to-jani2nnet> \
    --run "synic3(policy_reasoner=disabled)" \
    --applicability-mask
```

- Additional policy reasoning to compute stronger reasons

```sh
./build/police \
    --jani <path-to-jani-model> \
    --jani-additional-properties <path-to-jani-properties-file> \
    --policy <path-to-nnet> \
    --policy-adapter <path-to-jani2nnet> \
    --run "synic3(policy_reasoner=greedy_minimize)" \
    --applicability-mask
```

### ASNet policy

- With reason generalization disabled

```sh
./run_asnets.py \
    <path-to-domain.pddl> \
    <path-to-jani> \
    <path-to-property> \
    <path-to-asnet> \
    --args \
        --run "synic3(policy_reasoner=disabled)" \
        --applicability-mask
```

- Additional policy reasoning to compute stronger reasons

```sh
./run_asnets.py \
    <path-to-domain.pddl> \
    <path-to-jani> \
    <path-to-property> \
    <path-to-asnet> \
    --args \
        --run "synic3(policy_reasoner=lipa)" \
        --applicability-mask
```
