(define (domain n-puzzle-typed)
  (:requirements :typing)
  (:types position tile)
  (:constants p_7 - position t_3 - tile)
  (:predicates (at ?tile - tile ?p - position)
           (empty ?p - position)
           (LEFT ?p1 - position ?p2 - position)
           (ABOVE ?p1 - position ?p2 - position)
   )
  (:action move-up
     :parameters (?tile - tile ?x ?y - position)
     :precondition (and 
        (ABOVE ?y ?x)
        (empty ?x)
        (at ?tile ?y)
     )
     :effect (and 
        (at ?tile ?x)
        (empty ?y)
        (not (at ?tile ?y))
        (not (empty ?x))
    )
  )
  (:action move-down
     :parameters (?tile - tile ?x ?y - position)
     :precondition (and 
        (ABOVE ?x ?y)
        (empty ?x)
        (at ?tile ?y)
     )
     :effect (and 
        (at ?tile ?x)
        (empty ?y)
        (not (at ?tile ?y))
        (not (empty ?x))
    )
  )
  (:action move-left
     :parameters (?tile - tile ?x ?y - position)
     :precondition (and 
        (LEFT ?y ?x)
        (empty ?x)
        (at ?tile ?y)
     )
     :effect (and 
        (at ?tile ?x)
        (empty ?y)
        (not (at ?tile ?y))
        (not (empty ?x))
    )
  )
  (:action move-right
     :parameters (?tile - tile ?x ?y - position)
     :precondition (and 
        (LEFT ?x ?y)
        (empty ?x)
        (at ?tile ?y)
     )
     :effect (and 
        (at ?tile ?x)
        (empty ?y)
        (not (at ?tile ?y))
        (not (empty ?x))
    )
  )
)
