#pragma once

#ifdef POLICE_Z3

#include "police/expressions/expression.hpp"
#include "police/storage/id_map.hpp"
#include "police/storage/unordered_map.hpp"
#include "police/storage/value.hpp"
#include "police/storage/variable_space.hpp"

#include <memory>

namespace z3 {
class expr;
class context;
class solver;
class model;
} // namespace z3

namespace police {

namespace expressions {
class VariableSpace;
struct VariableType;
} // namespace expressions

class Z3Environment {
public:
    Z3Environment();
    ~Z3Environment();

    const z3::expr& add_variable(const VariableType& type);

    const z3::expr& get_variable(size_t var_id) const;

    size_t get_variable_id(const z3::expr& expr) const;

    z3::expr to_z3_expression(const expressions::Expression& expr);

    expressions::Expression from_z3_expression(const z3::expr& expr) const;

    z3::expr add_constant(const Value& value);

    [[nodiscard]]
    z3::context* context() const
    {
        return context_.get();
    }

    [[nodiscard]]
    size_t num_variables() const;

    void push_snapshot();

    void pop_snapshot();

    [[nodiscard]]
    const VariableSpace& get_variable_space() const
    {
        return vspace_;
    }

private:
    using Hash = police::hash<expressions::Expression>;
    struct Equal {
        bool operator()(
            const expressions::Expression& a,
            const expressions::Expression& b) const
        {
            return a.is_same(b);
        }
    };
    VariableSpace vspace_;
    unordered_map<size_t, size_t> z3_id_to_var_;
    vector<size_t> var_snapshots_;
    vector<z3::expr> vars_;
    id_map<expressions::Expression, Hash, Equal> expr_id_;
    vector<z3::expr> exprs_;
    std::unique_ptr<z3::context> context_;
    size_t var_counter_ = 0;
};

} // namespace police

#endif
