#pragma once

#if POLICE_Z3

#include "police/_bits/z3_env.hpp"
#include "police/storage/variable_space.hpp"

namespace z3 {
class model;
}

namespace police {

class Z3Model {
public:
    Z3Model(const Z3Environment* env, z3::model* model);

    [[nodiscard]]
    Value get_value(size_t var_idx) const
    {
        return get_value(vspace_->at(var_idx));
    }

    [[nodiscard]]
    size_t size() const
    {
        return vspace_->size();
    }

private:
    [[nodiscard]]
    Value get_value(const VariableSpace::value& var) const;

    z3::model* model_;
    const Z3Environment* env_;
    const VariableSpace* vspace_;
};

} // namespace police

#endif
