#pragma once

#if POLICE_Z3

#include "police/_bits/z3_env.hpp"
#include "police/_bits/z3_model.hpp"
#include "police/lp.hpp"

#include <memory>

namespace z3 {
class optimize;
class model;
class handle;
} // namespace z3

namespace police {

class Z3Optimizer {
public:
    Z3Optimizer();
    ~Z3Optimizer();

    [[nodiscard]]
    Z3Environment& get_environment();

    [[nodiscard]]
    const Z3Environment& get_environment() const;

    void add_variable(const VariableType& type);

    void add_constraint(const LinearConstraint& constraint);

    void add_constraint(const LinearConstraintDisjunction& constraint);

    void add_constraint(const MaxConstraint& constraint);

    void add_constraint(const IndicatorLPConstraint& constraint);

    void add_max_objective(const LinearExpression& expr);

    void add_min_objective(const LinearExpression& expr);

    void push_snapshot();

    void pop_snapshot();

    [[nodiscard]]
    bool check();

    [[nodiscard]]
    bool check(const vector<LinearConstraint>& assumptions);

    [[nodiscard]]
    real_t get_objective_value() const;

    [[nodiscard]]
    Z3Model get_model() const;

    [[nodiscard]]
    vector<LinearConstraint> get_unsat_core() const;

    void dump(std::ostream& out);

private:
    Z3Environment env_;
    mutable std::unique_ptr<z3::model> last_model_;
    std::unique_ptr<z3::optimize> optimizer_;
    unsigned objective_ = -1;
};

} // namespace police

#endif
