#pragma once

#if POLICE_Z3

#include "police/_bits/z3_env.hpp"
#include "police/_bits/z3_model.hpp"
#include "police/expressions/expression.hpp"
#include "police/storage/variable_space.hpp"

#include <memory>

namespace z3 {
class solver;
class model;
} // namespace z3

namespace police {
class Z3Solver {
public:
    Z3Solver();
    ~Z3Solver();

    [[nodiscard]]
    Z3Environment& get_environment();

    [[nodiscard]]
    const Z3Environment& get_environment() const;

    void add_variable(const VariableType& type);

    void add_constraint(const expressions::Expression& expr);

    void push_snapshot();

    void pop_snapshot();

    [[nodiscard]]
    bool check();

    [[nodiscard]]
    bool check(const vector<expressions::Expression>& assumptions);

    [[nodiscard]]
    Z3Model get_model() const;

    [[nodiscard]]
    vector<expressions::Expression> get_unsat_core() const;

    void dump(std::ostream& out);

private:
    Z3Environment env_;
    mutable std::unique_ptr<z3::model> last_model_;
    std::unique_ptr<z3::solver> solver_;
};
} // namespace police

#endif
