#pragma once

#include "police/base_types.hpp"
#include "police/linear_condition.hpp"
#include "police/linear_expression.hpp"
#include "police/storage/vector.hpp"

namespace police {

constexpr police::size_t SILENT_ACTION =
    std::numeric_limits<police::size_t>::max();

struct Assignment {
    size_t var_id;
    LinearExpression value;

    [[nodiscard]]
    std::string to_string() const;
};

struct Outcome {
    vector<Assignment> assignments;
};

struct Action {
    police::size_t label;
    LinearConstraintConjunction guard;
    vector<Outcome> outcomes;
};

} // namespace police
