#pragma once

#include "police/base_types.hpp"
#include "police/layer_bounds.hpp"

#include <memory>

namespace police::cg {

class Node;

struct PostProcessingResult {
    std::shared_ptr<Node> cg;
    vector<size_t> inputs;
};

class ComputeGraphPruner {
public:
    explicit ComputeGraphPruner(real_t epsilon);

    PostProcessingResult
    prune(std::shared_ptr<Node> root, const LayerBounds& input_bounds);

private:
    [[maybe_unused]]
    real_t epsilon_;
};

} // namespace police::cg
