#pragma once

#include "police/cg_pruner.hpp"
#include "police/compute_graph.hpp"
#include "police/storage/ffnn.hpp"
#include "police/storage/variable_space.hpp"

#include <string_view>

namespace police::cg {

std::shared_ptr<Node> from_ffnn(const FeedForwardNeuralNetwork<>& net);

std::shared_ptr<Node> parse_nnet_file(std::string_view file_name);

PostProcessingResult post_process(
    std::shared_ptr<Node> root,
    const vector<size_t>& input_vars,
    const VariableSpace& variables);

} // namespace police::cg
