#include "police/constraint_factories.hpp"

#include "police/action.hpp"
#include "police/variable_substitution.hpp"

namespace police {

LinearConstraintConjunction get_assignment_constraints(
    const EncodingInformation& info,
    const Outcome& outcome)
{
    const auto& assignments = outcome.assignments;
    assert(std::is_sorted(
        assignments.begin(),
        assignments.end(),
        [](const auto& a, const auto& b) { return a.var_id < b.var_id; }));
    LinearConstraintConjunction res;
    res.reserve(assignments.size());
    auto it = assignments.begin();
    auto var_idx = 0u;
    for (; it != assignments.end(); ++var_idx, ++it) {
        for (; var_idx < it->var_id; ++var_idx) {
            res.push_back(equal(
                var_expr(var_idx, info.out_vars),
                var_expr(var_idx, info.in_vars)));
        }
        assert(it->var_id == var_idx);
        res.push_back(equal(
            var_expr(it->var_id, info.out_vars),
            substitute_vars(it->value, info.in_vars)));
    }
    for (; var_idx < info.out_vars.size(); ++var_idx) {
        res.push_back(equal(
            var_expr(var_idx, info.out_vars),
            var_expr(var_idx, info.in_vars)));
    }
    return res;
}

} // namespace police
