#pragma once

#include "police/expressions/expression.hpp"
#include "police/storage/vector.hpp"
#include "police/utils/macros.hpp"

namespace police::expressions {

class BooleanCombination : public RawExpression {
public:
    CONSTRUCTORS_FROM_LIST(BooleanCombination, Expression, children)

    vector<Expression> children;

protected:
    void dump_(std::ostream& out, std::string_view connector) const;
};

class Conjunction final : public BooleanCombination {
public:
    using BooleanCombination::BooleanCombination;
    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;
    bool is_same(const Expression& other) const override;
    bool operator==(const Conjunction& other) const;
    std::size_t hash() const override;
    void dump(std::ostream& out) const override;
};

class Disjunction final : public BooleanCombination {
public:
    using BooleanCombination::BooleanCombination;
    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;
    bool is_same(const Expression& other) const override;
    bool operator==(const Disjunction& other) const;
    std::size_t hash() const override;
    void dump(std::ostream& out) const override;
};

} // namespace police::expressions
