#include "police/expressions/comparison.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"
#include "police/utils/hash.hpp"
#include <tuple>

namespace police::expressions {

Comparison::Comparison(Operator op, Expression left, Expression right)
    : op(std::move(op))
    , left(std::move(left))
    , right(std::move(right))
{
}

bool Comparison::operator==(const Comparison& other) const
{
    return op == other.op && left.is_same(other.left) &&
           right.is_same(other.right);
}

void Comparison::dump(std::ostream& out) const
{
    static const char* ops[] = {"==", "!=", "<", "<="};
    out << left << " " << ops[static_cast<int>(op)] << " " << right;
}

std::size_t Comparison::hash() const
{
    return hash_combine(
        typeid(Comparison).hash_code(),
        get_hash(static_cast<int>(op)),
        get_hash(std::tie(left, right)));
}

__POLICE_IMPLEMENT_EXPR_VISITORS(Comparison)

} // namespace police::expressions
