#include "police/expressions/constants.hpp"

#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"

#include <numbers>
#include <ostream>

namespace police::expressions {

Constant::Constant(Value value)
    : value(std::move(value))
{
}

bool Constant::operator==(const Constant& constant) const
{
    return value == constant.value;
}

bool Constant::operator==(const Value& value) const
{
    return this->value == value;
}

void Constant::dump(std::ostream& out) const
{
    out << value;
}

std::size_t Constant::hash() const
{
    return get_hash(value);
}

bool Constant::is_constant() const
{
    return true;
}

Value Constant::get_value() const
{
    return value;
}

Expression MakeConstantPi::operator()() const
{
    return MakeConstant()(static_cast<real_t>(std::numbers::pi));
}

Expression MakeConstantEuler::operator()() const
{
    return MakeConstant()(static_cast<real_t>(std::numbers::e));
}

__POLICE_IMPLEMENT_EXPR_VISITORS(Constant)

} // namespace police::expressions
