#pragma once

#include "police/expressions/expression.hpp"
#include "police/storage/value.hpp"

namespace police::expressions {

class Constant final : public RawExpression {
public:
    explicit Constant(Value value);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;

    bool is_same(const Expression& other) const override;
    bool operator==(const Constant& constant) const;
    bool operator==(const Value& value) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    bool is_constant() const override;

    Value get_value() const override;

    Value value;
};

struct MakeConstant {
    template <typename T>
    Expression operator()(T&& value) const
    {
        return Constant(Value(std::forward<T>(value)));
    }
};

struct MakeConstantPi {
    Expression operator()() const;
};

struct MakeConstantEuler {
    Expression operator()() const;
};

} // namespace police::expressions
