#include "police/expressions/derivative.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"
#include "police/utils/hash.hpp"

namespace police::expressions {

Derivative::Derivative(std::string_view identifier)
    : identifier(identifier)
{
}

bool Derivative::operator==(const Derivative& other) const
{
    return identifier == other.identifier;
}

void Derivative::dump(std::ostream& out) const
{
    out << "der(" << identifier << ")";
}

std::size_t Derivative::hash() const
{
    return hash_combine(typeid(Derivative).hash_code(), get_hash(identifier));
}

__POLICE_IMPLEMENT_EXPR_VISITORS(Derivative)
} // namespace police::expressions
