#pragma once

namespace police::expressions {

class BinaryFunctionCall;
class BinaryFunctionCallGeneric;
class Conjunction;
class Disjunction;
class Comparison;
class Constant;
class Derivative;
class FunctionCall;
class IdentifierReference;
class IfThenElse;
class Negation;
class NumericOperation;
class Variable;
class Expression;

class ExpressionVisitor {
public:
    virtual ~ExpressionVisitor() = default;
    virtual void visit(const BinaryFunctionCall& expr);
    virtual void visit(const BinaryFunctionCallGeneric& expr);
    virtual void visit(const Conjunction& expr);
    virtual void visit(const Disjunction& expr);
    virtual void visit(const Comparison& expr);
    virtual void visit(const Constant& expr);
    virtual void visit(const Derivative& expr);
    virtual void visit(const FunctionCall& expr);
    virtual void visit(const IdentifierReference& expr);
    virtual void visit(const IfThenElse& expr);
    virtual void visit(const Negation& expr);
    virtual void visit(const NumericOperation& expr);
    virtual void visit(const Variable& expr);
};

} // namespace police::expressions
