#include "police/expressions/filter_property.hpp"

namespace police::expressions {

FilterProperty::FilterProperty(
    Function fun,
    PropertyPtr values,
    PropertyPtr states)
    : fun(fun)
    , values(std::move(values))
    , states(std::move(states))
{
}

void FilterProperty::accept(ExpressionVisitor& visitor) const
{
    values->accept(visitor);
    states->accept(visitor);
}

void FilterProperty::transform(ExpressionTransformer& transformer)
{
    values->transform(transformer);
    states->transform(transformer);
}

} // namespace police::expressions
