#include "police/expressions/function_call.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"
#include "police/utils/hash.hpp"
#include <ostream>

namespace police::expressions {

FunctionCall::FunctionCall(Function function, Expression expr)
    : function(std::move(function))
    , expr(std::move(expr))
{
}

bool FunctionCall::operator==(const FunctionCall& other) const
{
    return function == other.function && expr.is_same(other.expr);
}

void FunctionCall::dump(std::ostream& out) const
{
    static const char* funs[] = {"floor", "ceil"};
    out << funs[static_cast<int>(function)] << "(" << expr << ")";
}

std::size_t FunctionCall::hash() const
{
    return hash_combine(
        typeid(FunctionCall).hash_code(),
        get_hash(static_cast<int>(function)),
        get_hash(expr));
}

__POLICE_IMPLEMENT_EXPR_VISITORS(FunctionCall)
} // namespace police::expressions
