#include "police/expressions/identifier_reference.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/expression_transformer.hpp"
#include "police/expressions/expression_visitor.hpp"

namespace police::expressions {

IdentifierReference::IdentifierReference(std::string_view identifier)
    : identifier(identifier)
{
}

bool IdentifierReference::operator==(const IdentifierReference& other) const
{
    return identifier == other.identifier;
}

void IdentifierReference::dump(std::ostream& out) const
{
    out << "#" << identifier;
}

std::size_t IdentifierReference::hash() const
{
    return get_hash(identifier);
}

__POLICE_IMPLEMENT_EXPR_VISITORS(IdentifierReference)
} // namespace police::expressions
