#pragma once

#include "police/base_types.hpp"
#include "police/expressions/expression.hpp"

namespace police::expressions {

class IdentifierReference final : public RawExpression {
public:
    explicit IdentifierReference(std::string_view identifier);
    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;
    identifier_name_t identifier;
    bool is_same(const Expression& e) const override;
    std::size_t hash() const override;
    bool operator==(const IdentifierReference& other) const;

    void dump(std::ostream& out) const override;
};

} // namespace police::expressions
