#pragma once

#include "police/expressions/expression.hpp"

namespace police::expressions {

class IfThenElse final : public RawExpression {
public:
    IfThenElse(
        Expression condition,
        Expression consequence,
        Expression alternative);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;
    bool is_same(const Expression& other) const override;
    bool operator==(const IfThenElse& other) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    Expression condition;
    Expression consequence;
    Expression alternative;
};

} // namespace police::expressions
