#pragma once

#include "police/expressions/property.hpp"
#include "police/expressions/reward_property.hpp"

namespace police::expressions {

class LongRunProperty final : public Property {
public:
    enum class Operator { SMIN, SMAX };

    LongRunProperty(
        Operator op,
        PropertyPtr expr,
        RewardAccumulation accumulate = RewardAccumulation::NONE);

    void accept(ExpressionVisitor& visitor) const override;
    void transform(ExpressionTransformer& transformer) override;

    Operator op;
    PropertyPtr expr;
    RewardAccumulation accumulate;
};

} // namespace police::expressions
