#pragma once

#include "police/expressions/expression.hpp"

namespace police::expressions {

class Negation final : public RawExpression {
public:
    explicit Negation(Expression expr);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;

    bool is_same(const Expression& expr) const override;
    bool operator==(const Negation& other) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    Expression expr;
};

} // namespace police::expressions
