#pragma once

#include "police/expressions/expression.hpp"
#include <cassert>
#include <type_traits>

namespace police::expressions {

class NumericOperation final : public RawExpression {
public:
    enum struct Operand { ADD, SUBTRACT, MULTIPLY, DIVISION, MODULO };

    NumericOperation(Operand operand, Expression left, Expression right);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;

    bool is_same(const Expression& e) const override;
    bool operator==(const NumericOperation& op) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    Operand operand;
    Expression left;
    Expression right;
};

template <typename Left, typename Right>
std::remove_cvref_t<Left>
evaluate(NumericOperation::Operand op, Left&& left, Right&& right)
{
    switch (op) {
    case NumericOperation::Operand::ADD: return left + right;
    case NumericOperation::Operand::SUBTRACT: return left - right;
    case NumericOperation::Operand::MULTIPLY: return left * right;
    case NumericOperation::Operand::DIVISION: return left / right;
    case NumericOperation::Operand::MODULO: return left % right;
    }
    // unreachable
    assert(false);
    return left;
}

} // namespace police::expressions
