#pragma once

#include "police/expressions/property.hpp"

namespace police::expressions {

class ProbabilityProperty final : public Property {
public:
    enum class Operator { PMIN, PMAX };

    ProbabilityProperty(Operator op, PropertyPtr expr);

    void accept(ExpressionVisitor& visitor) const override;
    void transform(ExpressionTransformer& transformer) override;

    Operator op;
    PropertyPtr expr;
};

} // namespace police::expressions
