#pragma once

#include "police/expressions/expression.hpp"
#include "police/expressions/expression_evaluator.hpp"
#include "police/storage/value.hpp"

namespace police::expressions {

class StateExpressionEvaluator {
public:
    template <typename StateType>
    struct ValueLookup {
        [[nodiscard]]
        Value operator()(size_t var_idx) const
        {
            return state->operator[](var_idx);
        }

        const StateType* state;
    };

    explicit StateExpressionEvaluator(expressions::Expression expr)
        : expr_(std::move(expr))
    {
    }

    template <typename StateType>
    [[nodiscard]]
    Value operator()(const StateType& state) const
    {
        expressions::ExpressionEvaluator<void*, ValueLookup<StateType>, false>
            evaluator({}, ValueLookup{&state});
        expr_.accept(evaluator);
        return (evaluator.value);
    }

private:
    expressions::Expression expr_;
};

class BooleanStateExpressionEvaluator : private StateExpressionEvaluator {
public:
    using StateExpressionEvaluator::StateExpressionEvaluator;

    template <typename StateType>
    [[nodiscard]]
    bool operator()(const StateType& state) const
    {
        return static_cast<bool>(StateExpressionEvaluator::operator()(state));
    }
};

template <typename StateType>
[[nodiscard]]
Value evaluate_state_expression(
    const expressions::Expression& expr,
    const StateType& state)
{
    return StateExpressionEvaluator(expr)(state);
}

} // namespace police::expressions
