#pragma once

#include "police/expressions/property.hpp"

namespace police::expressions {

class StatePredicateProperty final : public Property {
public:
    enum class Predicate { INITIAL, DEADLOCK, TIMELOCK };

    explicit StatePredicateProperty(Predicate predicate);

    void accept(ExpressionVisitor& visitor) const override;
    void transform(ExpressionTransformer& transformer) override;

    Predicate predicate;
};

} // namespace police::expressions
