#include "police/expressions/state_property.hpp"

namespace police::expressions {

StateProperty::StateProperty(Expression expr)
    : expr(std::move(expr))
{
}

void StateProperty::accept(ExpressionVisitor& visitor) const
{
    expr.accept(visitor);
}

void StateProperty::transform(ExpressionTransformer& transformer)
{
    expr.transform(transformer);
}

} // namespace police::expressions
