#pragma once

#include "police/base_types.hpp"
#include "police/expressions/expression.hpp"

namespace police::expressions {

class Variable final : public RawExpression {
public:
    explicit Variable(police::size_t var_id);

    void accept(ExpressionVisitor& visitor) const override;
    void
    transform(Expression& myptr, ExpressionTransformer& transformer) override;

    bool is_same(const Expression& other) const override;
    bool operator==(const Variable& var) const;

    std::size_t hash() const override;

    void dump(std::ostream& out) const override;

    police::size_t var_id;
};

} // namespace police::expressions
