#pragma once

#include "police/base_types.hpp"
#include "police/storage/vector.hpp"

namespace police {

template <typename>
class FeedForwardNeuralNetwork;
class NNLP;

/**
 * Adds variables and constraints to the LP evaluating the given network. This
 * method requires that variables representing the network's input layer are
 * already present. Their indices are provided -- in order -- via the input_vars
 * parameter. Variables representing the network's output neurons are allocated
 * contiguously. The method returns the index of first of these variables.
 **/
size_t encode_ffnn_in_lp(
    NNLP& lp,
    const FeedForwardNeuralNetwork<real_t>& n,
    const vector<size_t>& input_vars);

} // namespace police
