#pragma once

#include "police/base_types.hpp"
#include "police/expressions/expression.hpp"
#include "police/storage/vector.hpp"

#include <sys/types.h>

namespace police::jani {

struct Assignment {
    police::size_t var_id;
    expressions::Expression value;
    int index;
};

struct Outcome {
    police::size_t target;
    vector<Assignment> assignments;
};

struct Edge {
    police::size_t action;
    expressions::Expression guard;
    vector<Outcome> outcomes;
};

class Automaton {
public:
    Automaton(
        police::size_t id,
        identifier_name_t name,
        vector<identifier_name_t> location_names,
        vector<identifier_name_t> labels,
        vector<police::size_t> initial_locations,
        vector<police::size_t> local_variables);

    void set_id(police::size_t id) noexcept;

    void set_sync_labels(police::size_t num) noexcept;

    void add_edge(police::size_t location, Edge edge);

    [[nodiscard]]
    police::size_t get_id() const noexcept;

    [[nodiscard]]
    police::size_t num_locations() const noexcept;

    [[nodiscard]]
    const vector<Edge>& get_sync_edges(police::size_t loc) const noexcept;

    [[nodiscard]]
    const vector<Edge>& get_silent_edges(police::size_t loc) const noexcept;

    [[nodiscard]]
    const vector<police::size_t>& get_initial_locations() const noexcept;

    [[nodiscard]]
    vector<Edge>& get_sync_edges(police::size_t loc) noexcept;

    [[nodiscard]]
    police::size_t num_sync_labels() const noexcept
    {
        return num_sync_labels_;
    }

    [[nodiscard]]
    vector<identifier_name_t>& get_labels() noexcept
    {
        return labels_;
    }

    [[nodiscard]]
    const vector<identifier_name_t>& get_labels() const noexcept
    {
        return labels_;
    }

    [[nodiscard]]
    identifier_name_t get_name() const noexcept
    {
        return name_;
    }

    [[nodiscard]]
    const vector<size_t>& get_local_variables() const noexcept
    {
        return local_variables_;
    }

private:
    struct LocationEdges {
        vector<Edge> silent_edges;
        vector<Edge> sync_edges;
    };
    identifier_name_t name_;
    vector<identifier_name_t> location_names_;
    vector<identifier_name_t> labels_;
    vector<LocationEdges> edges_;
    vector<police::size_t> initial_locations_;
    vector<police::size_t> local_variables_;
    police::size_t num_sync_labels_;
    police::size_t id_;
};

} // namespace police::jani
