#pragma once

#include "police/base_types.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/storage/vector.hpp"

#include <nlohmann/json.hpp>
#include <optional>

namespace police::jani::parser {

struct CompositionElement {
    identifier_name_t automaton;
    vector<identifier_name_t> input_enable;
};

struct Synchronization {
    vector<std::optional<identifier_name_t>> synchronise;
    std::optional<identifier_name_t> result = std::nullopt;
};

struct Composition {
    vector<CompositionElement> elements;
    std::optional<vector<Synchronization>> syncs = std::nullopt;
};

JaniSchema<Composition> composition_schema();

} // namespace police::jani::parser
