#include "police/jani/parser/constant_declaration.hpp"
#include "police/base_types.hpp"
#include "police/jani/parser/comment.hpp"
#include "police/jani/parser/expression.hpp"
#include "police/jani/parser/language.hpp"
#include "police/jani/parser/schema_factory.hpp"
#include "police/jani/parser/types.hpp"

namespace police::jani::parser {

JaniSchema<ConstantDeclaration> constant_declaration_schema()
{
    static JaniSchema<ConstantDeclaration> schema{};
    static bool init = false;

    if (!init) {
        schema = (make_dictionary<factories::Construct<ConstantDeclaration>>(
            {},
            {comment_element},
            JaniDictArgument(
                lang::NAME,
                JaniString<factories::Construct<identifier_name_t>>()),
            JaniDictArgument(
                lang::TYPE,
                JaniMultiSchemata(basic_type_schema(), bounded_type_schema())),
            JaniDictArgument<std::optional<Expression>>(
                lang::VALUE,
                expression_schema(),
                true)));
        init = true;
    }

    return schema;
}

} // namespace police::jani::parser
