#pragma once

namespace police::jani::parser::lang {

// Keywords
constexpr char KIND[] = "kind";
constexpr char BASE[] = "base";
constexpr char LOWER_BOUND[] = "lower-bound";
constexpr char UPPER_BOUND[] = "upper-bound";
constexpr char CONSTANT[] = "constant";
constexpr char OP[] = "op";
constexpr char IF[] = "if";
constexpr char THEN[] = "then";
constexpr char ELSE[] = "else";
constexpr char LEFT[] = "left";
constexpr char RIGHT[] = "right";
constexpr char EXP[] = "exp";
constexpr char VAR[] = "var";
constexpr char ELEMENTS[] = "elements";
constexpr char AUTOMATON[] = "automaton";
constexpr char INPUT_ENABLE[] = "input-enable";
constexpr char COMMENT[] = "comment";
constexpr char SYNCS[] = "syncs";
constexpr char SYNCHRONISE[] = "synchronise";
constexpr char RESULT[] = "result";
constexpr char NAME[] = "name";
constexpr char TYPE[] = "type";
constexpr char VALUE[] = "value";
constexpr char JANI_VERSION[] = "jani-version";
constexpr char METADATA[] = "metadata";
constexpr char FEATURES[] = "featues";
constexpr char ACTIONS[] = "actions";
constexpr char CONSTANTS[] = "constants";
constexpr char VARIABLES[] = "variables";
constexpr char RESTRICT_INITIAL[] = "restrict-initial";
constexpr char INITIAL_VALUE[] = "initial-value";
constexpr char PROPERTIES[] = "properties";
constexpr char AUTOMATA[] = "automata";
constexpr char SYSTEM[] = "system";
constexpr char LOCATIONS[] = "locations";
constexpr char TIME_PROGRESS[] = "time-progress";
constexpr char TRANSIENT_VALUES[] = "transient-values";
constexpr char INITIAL_LOCATIONS[] = "initial-locations";
constexpr char TRANSIENT[] = "transient";
constexpr char EDGES[] = "edges";
constexpr char LOCATION[] = "location";
constexpr char ACTION[] = "action";
constexpr char RATE[] = "rate";
constexpr char GUARD[] = "guard";
constexpr char DESTINATIONS[] = "destinations";
constexpr char PROBABILITY[] = "probability";
constexpr char ASSIGNMENTS[] = "assignments";
constexpr char REF[] = "ref";
constexpr char INDEX[] = "index";
constexpr char EXPRESSION[] = "expression";
constexpr char LOWER[] = "lower";
constexpr char LOWER_EXCLUSIVE[] = "lower-exclusive";
constexpr char UPPER[] = "upper";
constexpr char UPPER_EXCLUSIVE[] = "upper-exclusive";
constexpr char FUN[] = "fun";
constexpr char VALUES[] = "values";
constexpr char STATES[] = "states";
constexpr char ACCUMULATE[] = "accumulate";
constexpr char REACH[] = "reach";
constexpr char STEP_INSTANT[] = "step-instant";
constexpr char TIME_INSTANT[] = "time-instant";
constexpr char REWARD_INSTANTS[] = "reward-instants";
constexpr char INSTANT[] = "instant";
constexpr char STEP_BOUNDS[] = "step-bounds";
constexpr char TIME_BOUNDS[] = "time-bounds";
constexpr char REWARD_BOUNDS[] = "reward-bounds";
constexpr char BOUNDS[] = "bounds";

// Metadata
constexpr char VERSION[] = "version";
constexpr char AUTHOR[] = "author";
constexpr char DESCRIPTION[] = "description";
constexpr char DOI[] = "doi";
constexpr char URL[] = "url";

// Model types
constexpr char LTS[] = "lts";
constexpr char DTMC[] = "dtmc";
constexpr char CTMC[] = "ctmc";
constexpr char MDP[] = "mdp";
constexpr char CTMDP[] = "ctmdp";
constexpr char MA[] = "ma";
constexpr char TA[] = "ta";
constexpr char PTA[] = "pta";
constexpr char STA[] = "sta";
constexpr char HA[] = "ha";
constexpr char PHA[] = "pha";
constexpr char SHA[] = "sha";

// Model features
constexpr char ARRAYS[] = "arrays";
constexpr char DATATYPES[] = "datatypes";
constexpr char DERIVED_OPERATORS[] = "derived-operators";
constexpr char EDGE_PRIORITIES[] = "edge-priorities";
constexpr char FUNCTIONS[] = "functions";
constexpr char HYPERBOLIC_FUNCTIONS[] = "hyperbolic-functions";
constexpr char NAMED_EXPRESSIONS[] = "named-expressions";
constexpr char NONDET_SELECTION[] = "nondet-selection";
constexpr char STATE_EXIT_REWARDS[] = "state-exit-rewards";
constexpr char TRADEOFF_PROPERTIES[] = "tradeoff-properties";
constexpr char TRIGONOMETRIC_FUNCTIONS[] = "trigonometric-functions";

// Types
constexpr char BOOL[] = "bool";
constexpr char INT[] = "int";
constexpr char REAL[] = "real";
constexpr char CLOCK[] = "clock";
constexpr char CONTINUOUS[] = "continuous";
constexpr char BOUNDED[] = "bounded";

// Expressions
constexpr char FLOOR[] = "floor";
constexpr char CEIL[] = "ceil";
constexpr char DER[] = "der";
constexpr char DIV[] = "/";
constexpr char PLUS[] = "+";
constexpr char MINUS[] = "-";
constexpr char TIMES[] = "*";
constexpr char MOD[] = "%";
constexpr char LESS[] = "<";
constexpr char GREATER[] = ">";
constexpr char LESS_EQUAL[] = "≤";
constexpr char GREATER_EQUAL[] = "≥";
constexpr char EQUAL[] = "=";
constexpr char NOT_EQUAL[] = "≠";
constexpr char NEGATE[] = "¬";
constexpr char OR[] = "∨";
constexpr char AND[] = "∧";
constexpr char IMPLIES[] = "⇒";
constexpr char ITE[] = "ite";
constexpr char POW[] = "pow";
constexpr char LOG[] = "log";

// Constants
constexpr char EULER[] = "e";
constexpr char PI[] = "π";

// Properties
constexpr char INITIAL[] = "initial";
constexpr char DEADLOCK[] = "deadlock";
constexpr char TIMELOCK[] = "timelock";
constexpr char FILTER[] = "filter";
constexpr char MIN[] = "min";
constexpr char MAX[] = "max";
constexpr char SUM[] = "sum";
constexpr char AVG[] = "avg";
constexpr char COUNT[] = "count";
constexpr char ARGMIN[] = "argmin";
constexpr char ARGMAX[] = "argmax";
constexpr char STEPS[] = "steps";
constexpr char TIME[] = "time";

constexpr char PMIN[] = "Pmin";
constexpr char PMAX[] = "Pmax";
constexpr char EXISTS[] = "∃";
constexpr char FORALL[] = "∀";
constexpr char EMIN[] = "Emin";
constexpr char EMAX[] = "Emax";
constexpr char SMIN[] = "Smin";
constexpr char SMAX[] = "Smax";
constexpr char UNTIL[] = "U";
constexpr char WEAK_UNTIL[] = "W";

constexpr char FINALLY[] = "F";
constexpr char GLOBALLY[] = "G";

} // namespace police::jani::parser::lang
