#pragma once

#include "police/jani/parser/expression.hpp"
#include "police/jani/parser/schema_factory.hpp"

#include <type_traits>
#include <variant>

namespace police::jani::parser {

struct BoolType {};
struct IntegerType {};
struct RealType {};
template <typename BaseType>
struct BoundedType {
    std::optional<Expression> lower_bound = std::nullopt;
    std::optional<Expression> upper_bound = std::nullopt;
};
using BoundedIntType = BoundedType<IntegerType>;
using BoundedRealType = BoundedType<RealType>;
struct ClockType {};
struct ContinuousType {};

using Type = std::variant<
    BoolType,
    IntegerType,
    RealType,
    BoundedIntType,
    BoundedRealType,
    ClockType,
    ContinuousType>;

JaniSchema<Type> basic_type_schema();
JaniSchema<Type> bounded_type_schema();
JaniSchema<Type> type_schema();

template <
    typename F,
    typename Type_cv,
    std::enable_if_t<std::is_same_v<std::remove_cvref_t<Type_cv>, Type>, int> =
        0>
void apply_to_all_expressions(Type_cv&& type, F fn = F())
{
    std::visit(
        [&fn](auto&& type) {
            using T = std::decay_t<decltype(type)>;
            if constexpr (
                std::is_same_v<T, BoundedIntType> ||
                std::is_same_v<T, BoundedRealType>) {
                if (type.lower_bound.has_value()) {
                    fn(type.lower_bound.value());
                }
                if (type.upper_bound.has_value()) {
                    fn(type.upper_bound.value());
                }
            }
        },
        type);
}

} // namespace police::jani::parser
