#include "police/lp.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/variable.hpp"
#include "police/macros.hpp"

#include <cassert>
#include <limits>
#include <string>

namespace police {

LPVariable::LPVariable(
    real_t lower_bound,
    real_t upper_bound,
    real_t obj_coef,
    Type type,
    std::string_view name)
    : name(name)
    , lower_bound(lower_bound)
    , upper_bound(upper_bound)
    , obj_coef(obj_coef)
    , type(type)
{
}

IndicatorLPConstraint::IndicatorLPConstraint(
    size_t indicator_var,
    bool indicator_value,
    LinearConstraint constraint)
    : indicator_var(indicator_var)
    , indicator_value(indicator_value)
    , constraint(std::move(constraint))
{
}

expressions::Expression MaxConstraint::as_expression() const
{
    assert(!elements.empty());
    expressions::Expression max = expressions::Variable(elements.back());
    for (int i = elements.size() - 2; i >= 0; --i) {
        max = expressions::max(expressions::Variable(elements[i]), max);
    }
    if (c != -std::numeric_limits<real_t>::infinity()) {
        max = expressions::max(max, Value(c));
    }
    return expressions::equal(expressions::Variable(y), max);
}

LP::LP(LPOptimizationKind)
{
}

LP::constraint_ref LP::add_constraint(const disjunctive_constraint_type&)
{

    POLICE_RUNTIME_ERROR(
        get_name() << " does not support disjunctive constraints");
}

LP::constraint_ref LP::add_constraint(const indicator_constraint_type&)
{
    POLICE_RUNTIME_ERROR(
        get_name() << " does not support indicator constraints");
}

LP::constraint_ref LP::add_constraint(const max_constraint_type&)
{
    POLICE_RUNTIME_ERROR(get_name() << " does not support max constraints");
}

vector<LP::linear_constraint_type> LP::get_unsat_core() const
{
    POLICE_RUNTIME_ERROR(
        get_name() << " does not support unsat core extraction");
}

void LP::dump(std::ostream&) const
{
}

void LP::dump_model(std::ostream&) const
{
}

} // namespace police
