#pragma once

#include "police/action.hpp"
#include "police/storage/flat_state.hpp"
#include "police/successor_generator/applicable_actions_generator.hpp"

namespace police {

template <typename BasePolicy>
class MaskedPolicy {
public:
    MaskedPolicy(const BasePolicy* policy, const vector<Action>* actions)
        : aops_gen_(actions)
        , actions_(actions)
        , policy_(policy)
    {
    }

    [[nodiscard]]
    const BasePolicy* get_base_policy() const
    {
        return policy_;
    }

    [[nodiscard]]
    size_t operator()(const flat_state& state) const
    {
        labels_.clear();
        const auto aops = aops_gen_(state);
        for (auto it = aops.begin(); it != aops.end(); ++it) {
            const auto& a = this->actions_->at(*it);
            if (a.label != SILENT_ACTION) {
                labels_.push_back(a.label);
            }
        }
        std::sort(labels_.begin(), labels_.end());
        labels_.erase(
            std::unique(labels_.begin(), labels_.end()),
            labels_.end());
        if (labels_.empty()) {
            return SILENT_ACTION;
        }
        if (labels_.size() == 1) {
            return labels_.back();
        }
        auto selected =
            policy_->operator()(state, labels_.begin(), labels_.end());
        assert(selected != labels_.end());
        return *selected;
    }

private:
    mutable vector<size_t> labels_;
    successor_generator::ApplicableActionsGenerator aops_gen_;
    const vector<Action>* actions_;
    const BasePolicy* policy_;
};

} // namespace police
