#pragma once

#include "police/nnlp_factory.hpp"
#include "police/nnlp_wrapper.hpp"
#include "police/storage/variable_space.hpp"
#include "police/storage/vector.hpp"

namespace police {

class NNLPBranchNBound final : public NNLPWrapper {
public:
    using NNLPWrapper::NNLPWrapper;

    [[nodiscard]]
    Status solve() override;

    [[nodiscard]]
    model_type get_model() const override;

    void clear() override;

    void pop_snapshot() override;

    size_t add_variable(const VariableType& var_type) override;

    bool has_integer_variable() const override;

private:
    struct Branch {
        real_t old_lb;
        real_t old_ub;
        real_t new_lb;
        real_t new_ub;
        size_t var;
        size_t back_ref;
        bool flag = false;
    };

    size_t get_domain_size(size_t var) const;

    std::pair<bool, size_t> find_split_variable(const model_type& model) const;

    void push_branches(
        vector<Branch>& branches,
        size_t var_ref,
        const model_type& model,
        size_t back_ref) const;

    VariableSpace non_relaxed_vspace_;
    SATModel last_model_;
    std::vector<size_t> int_vars_;
    real_t error_margin_ = 1e-6;
};

class NNLPBranchNBoundFactory : public NNLPFactory {
public:
    explicit NNLPBranchNBoundFactory(NNLPFactory* sub_factory);

    NNLP* make() const override;

private:
    NNLPFactory* sub_;
};

} // namespace police
