#pragma once

#include "police/action.hpp"
#include "police/base_types.hpp"
#include "police/encoding_information.hpp"
#include "police/linear_condition.hpp"
#include "police/nnlp.hpp"
#include "police/storage/variable_space.hpp"
#include "police/storage/vector.hpp"

namespace police {

vector<size_t> get_vars_in_input_order(
    const vector<size_t>& state_vars,
    const vector<size_t>& input_order);

vector<size_t> get_action_vars(const vector<size_t>& nn_output, size_t offset);

EncodingInformation initialize_nnlp(NNLP& lp, const VariableSpace& vspace);

void add_no_terminals(
    NNLP& lp,
    const vector<LinearConstraintDisjunction>& not_terminal);

void add_state_variables(
    NNLP& lp,
    EncodingInformation& info,
    const VariableSpace& vspace);

void add_guard(
    NNLP& lp,
    const EncodingInformation& info,
    const LinearConstraintConjunction& guard);

void add_successor_constraints_for_outcome(
    NNLP& lp,
    const EncodingInformation& info,
    const Outcome& outcome);

void add_successor_constraints_for_edge(
    NNLP& lp,
    const EncodingInformation& info,
    const Action& edge);

} // namespace police
