#pragma once

#include "police/action.hpp"
#include "police/base_types.hpp"
#include "police/encoding_information.hpp"
#include "police/nn_policy.hpp"
#include "police/nnlp.hpp"
#include "police/nnlp_lp.hpp"

namespace police {

vector<size_t> add_nn(
    NNLP& lp,
    const EncodingInformation& info,
    const NeuralNetworkPolicy& policy);

void add_policy_selection_constraints_without_app_filter(
    NNLP& lp,
    const EncodingInformation& info,
    size_t label_id,
    size_t num_labels);

void add_policy_selection_constraints_with_app_filter(
    NNLP& lp,
    const EncodingInformation& info,
    size_t label_id,
    vector<Action>::const_iterator first,
    vector<Action>::const_iterator last);

void add_successor_constraints_for_outcome(
    NNLP& lp,
    const EncodingInformation& info,
    const Outcome& outcome);

void add_successor_constraints_for_edge(
    NNLP& lp,
    const EncodingInformation& info,
    const Action& edge);

void encode_transition_without_app_filter(
    NNLP& lp,
    const EncodingInformation& info,
    const Action& edge,
    size_t num_labels);

void encode_transition_with_app_filter(
    NNLP& lp,
    const EncodingInformation& info,
    const vector<Action>& edges,
    size_t edge_idx);

void encode_all_transitions_without_app_filter(
    NNLPLP& lp,
    const EncodingInformation& info,
    vector<Action>::const_iterator first,
    vector<Action>::const_iterator last);

void encode_all_transitions_with_app_filter(
    NNLPLP& lp,
    const EncodingInformation& info,
    vector<Action>::const_iterator first,
    vector<Action>::const_iterator last);

} // namespace police
