#include "police/nnlp_wrapper.hpp"

namespace police {

NNLPWrapper::NNLPWrapper(std::unique_ptr<NNLP> lp)
    : lp_(std::move(lp))
{
}

void NNLPWrapper::push_snapshot()
{
    lp_->push_snapshot();
}

void NNLPWrapper::pop_snapshot()
{
    lp_->pop_snapshot();
}

void NNLPWrapper::clear()
{
    lp_->clear();
}

void NNLPWrapper::set_input_index(size_t var_id, size_t index)
{
    lp_->set_input_index(var_id, index);
}

void NNLPWrapper::set_output_index(size_t var_id, size_t index)
{
    lp_->set_output_index(var_id, index);
}

void NNLPWrapper::set_variable_upper_bound(size_t var_ref, real_t ub)
{
    lp_->set_variable_upper_bound(var_ref, ub);
}

void NNLPWrapper::set_variable_lower_bound(size_t var_ref, real_t lb)
{
    lp_->set_variable_lower_bound(var_ref, lb);
}

void NNLPWrapper::add_assumption(const linear_constraint_type& constraint)
{
    lp_->add_assumption(constraint);
}

void NNLPWrapper::add_constraint(const linear_constraint_type& constraint)
{
    lp_->add_constraint(constraint);
}

void NNLPWrapper::add_constraint(const relu_constraint_type& constraint)
{
    lp_->add_constraint(constraint);
}

void NNLPWrapper::add_constraint(const max_constraint_type& constraint)
{
    lp_->add_constraint(constraint);
}

void NNLPWrapper::add_constraint(
    const linear_constraint_disjunction_type& constraint)
{
    lp_->add_constraint(constraint);
}

NNLP::Status NNLPWrapper::solve()
{
    return lp_->solve();
}

NNLP::model_type NNLPWrapper::get_model() const
{
    return lp_->get_model();
}

const NNLP* NNLPWrapper::get_underlying_lp() const
{
    return lp_.get();
}

NNLP* NNLPWrapper::get_underlying_lp()
{
    return lp_.get();
}

size_t NNLPWrapper::add_variable(const VariableType& var_type)
{
    return lp_->add_variable(var_type);
}

} // namespace police
