#pragma once

#include "police/storage/unordered_map.hpp"
#include "police/storage/vector.hpp"

#include <memory>
#include <string>
#include <string_view>

namespace police {

class ParseTree {
public:
    ParseTree() = default;
    explicit ParseTree(std::string_view name);

    [[nodiscard]]
    static ParseTree parse(std::string_view arg);

    void add_argument(ParseTree arg);

    void add_argument(std::string_view key, ParseTree arg);

    [[nodiscard]]
    bool is_leaf() const
    {
        return args.empty() && kwargs.empty();
    }

    std::string raw;
    std::string name;
    vector<std::shared_ptr<ParseTree>> args;
    unordered_map<std::string, std::shared_ptr<ParseTree>> kwargs;
};

} // namespace police
