#pragma once

#include "police/execution_unit.hpp"
#include "police/plan_validator.hpp"
#include "police/storage/path.hpp"

namespace police {

template <typename SuccessorGenerator>
class PlanValidatorUnit final : public ExecutionUnit {
public:
    PlanValidatorUnit(PlanValidator<SuccessorGenerator> validator, Path path);

    std::string_view name() const override { return "plan validator"; }

    void run() override;

private:
    PlanValidator<SuccessorGenerator> validator_;
    Path path_;
};

} // namespace police
