#include "police/random_order.hpp"

#include "police/arguments.hpp"
#include "police/model.hpp"
#include "police/option.hpp"
#include "police/utils/rng.hpp"
#include "police/variable_order_chooser.hpp"

#include <numeric>

namespace police {

RandomVariableOrder::RandomVariableOrder(size_t num_vars, RNG& rng)
{
    vector<size_t> ranks(num_vars, 0);
    std::iota(ranks.begin(), ranks.end(), 0);
    rng.shuffle(ranks.begin(), ranks.end());
    set_variable_ranks(std::move(ranks));
}

namespace {

PointerOption<VariableOrderChooser>
    _option("random", [](const Arguments& args) {
        return std::make_shared<RandomVariableOrder>(
            args.get_model().variables.size(),
            *args.get_rng());
    });

} // namespace

} // namespace police
