#pragma once

#include "police/smt.hpp"
#include "police/smt_factory.hpp"
#include "police/storage/variable_space.hpp"

#ifdef POLICE_Z3
#include "police/_bits/z3_solver.hpp"
#endif

namespace police {

class Z3SMT final : public SMT {
public:
    constexpr static int_t RESET_EVERY_SNAPSHOTS = 111;

    Z3SMT();

    [[nodiscard]]
    Status solve() override;

    [[nodiscard]]
    Status solve(const vector<expressions::Expression>& assumptions) override;

    [[nodiscard]]
    SMT::model_type get_model() const override;

    [[nodiscard]]
    vector<expressions::Expression> get_unsat_core() const override;

    void dump(std::ostream& out) const override;

private:
    void do_push_snapshot() override;

    void do_pop_snapshot() override;

    void do_clear() override;

    size_t do_add_variable(std::string_view name, VariableType type) override;

    void do_add_constraint(const expressions::Expression& expr) override;

#ifdef POLICE_Z3
    std::unique_ptr<Z3Solver> solver_;
    int reset_counter_ = RESET_EVERY_SNAPSHOTS;
#endif
};

class Z3SMTFactory : public SMTFactory {
private:
    [[nodiscard]]
    SMT* make() const override
    {
        return new Z3SMT();
    }
};

} // namespace police
