#pragma once

#include "police/base_types.hpp"
#include "police/storage/vector.hpp"

#include <memory>

namespace police {

struct Model;
struct LinearCondition;
struct VerificationProperty;
class SMTFactory;

class CGPolicy;
class AddTreePolicy;
class NeuralNetworkPolicy;

namespace expressions {
class Expression;
}

class StaticVariableRemover {
public:
    StaticVariableRemover(
        const Model& model,
        const expressions::Expression& init,
        std::shared_ptr<SMTFactory> smt);

    [[nodiscard]]
    bool has_static_variables() const;

    [[nodiscard]]
    size_t num_static_variables() const;

    void substitute_variable_ids(vector<size_t>& var_ids);

    void apply(Model& model);

    void apply(VerificationProperty& model);

    void apply(expressions::Expression& expr);

    void apply(LinearCondition& cond);

    void apply(std::shared_ptr<CGPolicy>& policy);

    void apply(std::shared_ptr<AddTreePolicy>& policy);

    void apply(std::shared_ptr<NeuralNetworkPolicy>& policy);

private:
    vector<bool> is_static_;
    vector<int_t> value_;
    vector<size_t> new_id_;
};

} // namespace police
