#pragma once

#include <cassert>
#include <type_traits>
#include <utility>

namespace police {

template <typename BaseVector>
struct dynamic_size_vector_adapter : public BaseVector {
    using allocator_type = typename BaseVector::allocator_type;
    using const_iterator = typename BaseVector::const_iterator;
    using const_pointer = typename BaseVector::const_pointer;
    using const_reference = typename BaseVector::const_reference;
    using const_reverse_iterator = typename BaseVector::const_reverse_iterator;
    using difference_type = typename BaseVector::difference_type;
    using iterator = typename BaseVector::iterator;
    using pointer = typename BaseVector::pointer;
    using reference = typename BaseVector::reference;
    using reverse_iterator = typename BaseVector::reverse_iterator;
    using size_type = typename BaseVector::size_type;
    using value_type = typename BaseVector::value_type;

    static_assert(std::is_default_constructible_v<value_type>);

    using BaseVector::BaseVector;
    constexpr dynamic_size_vector_adapter(const BaseVector& base)
        : BaseVector(base)
    {
    }
    constexpr dynamic_size_vector_adapter(BaseVector&& base) noexcept
        : BaseVector(std::move(base))
    {
    }

    [[nodiscard]]
    constexpr reference operator[](size_type idx)
    {
        if (idx >= this->size()) {
            this->resize(idx + 1, value_type());
        }
        return BaseVector::operator[](idx);
    }

    [[nodiscard]]
    constexpr const_reference operator[](size_type idx) const
    {
        assert(idx < this->size());
        return BaseVector::operator[](idx);
    }

    [[nodiscard]]
    constexpr reference at(size_type idx)
    {
        return this->operator[](idx);
    }

    [[nodiscard]]
    constexpr const_reference at(size_type idx) const
    {
        return this->operator[](idx);
    }
};

} // namespace police
