#pragma once

#include "police/storage/explicit_state_container.hpp"
#include "police/storage/variable_space.hpp"

namespace police {

class StateRegistry : public explicit_state_container<> {
public:
    using explicit_state_container<>::explicit_state_container;
    StateRegistry(size_t floats, const vector<BoundedIntType>& integers);
    explicit StateRegistry(const VariableSpace& variables);
};

using StateId = StateRegistry::size_t;

using FlatState = flat_state;

class CompressedState : public StateRegistry::state_t {
public:
    CompressedState(StateId state_id, StateRegistry::state_t&& data)
        : StateRegistry::state_t(std::move(data))
        , state_id_(state_id)
    {
    }

    [[nodiscard]]
    StateId get_state_id() const
    {
        return state_id_;
    }

private:
    StateId state_id_;
};

struct StateIdGetter {
    [[nodiscard]]
    StateId operator()(const CompressedState& state) const
    {
        return state.get_state_id();
    }
};

struct StateLookup {
    [[nodiscard]]
    CompressedState operator()(StateId state_id) const
    {
        assert(state_id < registry->size());
        return {state_id, (*registry)[state_id]};
    }

    StateRegistry* registry;
};

} // namespace police
